# 다익스트라 알고리즘

다익스트라(dijkstra) 알고리즘은 그래프에서 한 정점(노드)에서 다른 정점까지의 최단 경로를 구하는 알고리즘 중 하나이다.  
이 과정에서 도착 정점 뿐만 아니라 모든 다른 정점까지 최단 경로로 방문하며 각 정점까지의 최단 경로를 모두 찾게 된다.  
매번 최단 경로의 정점을 선택해 탐색을 반복하는 것이다.

참고로 그래프 알고리즘 중 최소 비용을 구하는 데는 다익스트라 알고리즘 외에도 벨만-포드 알고리즘, 프로이드 워샬 알고리즘 등이 있다.


## 알고리즘 동작 단계
1. 출발 노드와 도착 노드를 설정한다.  
2. **'최단 거리 테이블'** 을 초기화한다.  
3. 현재 위치한 노드의 인접 노드 중 방문하지 않은 노드를 구별하고, 방문하지 않은 노드 중 거리가 가장 짧은 노드를 선택한다. 그 노드를 방문 처리한다.  
4. 해당 노드를 거쳐 다른 노드로 넘어가는 **간선 비용(가중치)** 을 계산해 '최단 거리 테이블'을 업데이트한다.  
5. 3~4의 과정을 반복한다.  

**'최단 거리 테이블'** 은 1차원 배열로, N개 노드까지 오는 데 필요한 최단 거리를 기록한다. N개(1부터 시작하는 노드 번호와 일치시키려면 N + 1개) 크기의 배열을 선언하고 큰 값을 넣어 초기화시킨다.

'노드 방문 여부 체크 배열'은 방문한 노드인지 아닌지 기록하기 위한 배열로, 크기는 '최단 거리 테이블'과 같다. 기본적으로는 False로 초기화하여 방문하지 않았음을 명시한다.

## 동작 예시
[과정1]  <img width="600" alt="스크린샷 2023-01-19 오후 8 00 26" src="https://user-images.githubusercontent.com/70997596/213428150-583c82e5-2236-46f7-9756-3ff28e0a0b4e.png">

출발 노드는 1번, 도착 노드는 6번이라 하고 거리 테이블을 전부 큰 값, 여기서는 inf(무한대)로 초기화했다.  
각 노드들을 잇는 간선의 가중치 역시 표시했다.

[과정2]  <img width="600" alt="스크린샷 2023-01-19 오후 8 00 51" src="https://user-images.githubusercontent.com/70997596/213428175-d84fde77-36d1-4921-b7e4-d8182cb035ec.png">

출발 노드를 먼저 선택하고 거리를 0으로 한다.

[과정3]  <img width="600" alt="스크린샷 2023-01-19 오후 8 01 14" src="https://user-images.githubusercontent.com/70997596/213428186-7d158f70-f7a1-4208-9af5-a7b4fa36e283.png">

1번 노드와 연결된 인접 노드는 2, 4이다.   
그곳까지 가는 거리를 각각 기존의 거리값과 비교해 최솟값으로 업데이트한다.  
가령 2의 경우 inf와 2 중 작은 값인 2를 택해 할당한다.  
또한 인접 노드까지의 거리를 모두 업데이트한 1번 노드는 방문 표시를 한다.  
최근 갱신한 테이블 기준, 방문하지 않는 노드 중 가장 거리값이 작은 번호를 다음 노드로 택한다. 위 상태에서는 4번 노드이다.

[과정4]  <img width="600" alt="스크린샷 2023-01-19 오후 8 02 01" src="https://user-images.githubusercontent.com/70997596/213428201-2292cfd0-abaf-48fe-8084-cc7468820460.png">

4번 노드에서 같은 작업을 수행한다. 4번과 연결된 2, 5번까지 오는 거리를 계산한다.  
가령 5의 경우엔 4번까지 오는 데 필요한 거리 + 4->5 간선의 가중치 값인 2와 기존의 값인 inf 중 최솟값을 계산하고, 2번 노드의 경우엔 기존 값인 2와 4번을 거쳐가는 값인 1+2 = 3을 비교한다.  
그렇다면 2번 노드는 기존 값이 더 크므로 업데이트하지 않는다.  
즉, 1번에서 바로 2번으로 가는 것이 1->4를 거쳐 2번으로 가는 길보다 더 적게 걸린단 뜻이다.  
다음으로 선택될 노드는 아직 방문하지 않은 노드 2, 3, 5, 6 중 거리값이 가장 작은 노드이므로 2 또는 5이다.  
거리 값이 같다면 일단 인덱스가 작은 노드를 택한다고 하고 2번으로 가보자.

[과정5]  <img width="600" alt="스크린샷 2023-01-19 오후 8 03 00" src="https://user-images.githubusercontent.com/70997596/213428210-339c0657-7c23-4e5b-8ab4-7cde2d7fcfe5.png">

2번 노드와 연결된 3, 4번 노드에 대해 같은 과정을 반복한다.  
그 다음 노드는 3, 5, 6번 중 가장 거리값이 작은 5번 노드가 되겠다.

[과정6]  <img width="600" alt="스크린샷 2023-01-19 오후 8 03 29" src="https://user-images.githubusercontent.com/70997596/213428218-b0125aaf-27fa-4439-9323-46ac5520dce6.png">

5번 노드와 연결된 6번 노드에 같은 과정을 반복한다.  
다음 노드를 선택해야 하는데, 아직 방문하지 않은 3번과 6번 중 거리값이 작은 것은 6번이다.  
그런데 6번은 더 이어지는 노드도 없는데다 도착 노드이다. 따라서 알고리즘을 종료한다.

[과정7]  <img width="600" alt="스크린샷 2023-01-19 오후 8 03 51" src="https://user-images.githubusercontent.com/70997596/213428230-8c60c9eb-1b9d-4e3f-a783-6a10c5387f57.png">

최종적으로는 1번에서 6번까지 오는 데 1 - 4 - 5 - 6의 경로를 거치고 최소 거리는 4가 된다.

## 구현 방법
다익스트라 알고리즘을 구현하는 방법에는 '방문하지 않은 노드'를 다루는 방식에서 '순차 탐색'을 할 것이나 '우선순위 큐'를 쓸 것이냐로 나뉜다.  
또한, 다익스트라 알고리즘은 가중치가 양수일 때만 사용 가능하다는 중요한 특징이 있다.

### **순차 탐색으로 구현하기**
'방문하지 않은 노드 중 거리값이 가장 작은 노드'를 선택해 다음 탐색 노드로 삼는다. 그 노드를 찾는 방식이 순차 탐색이 된다. 즉 거리 테이블의 앞에서부터 찾아내야 하므로 노드의 개수만큼 순차 탐색을 수행해야 한다. 따라서 노드 개수가 N이라고 할 때 각 노드마다 최소 거리값을 갖는 노드를 선택해야 하는 순차 탐색이 수행되므로 **(N−1)×N=O(N^2)** 의 시간이 걸린다.  

### **우선순위 큐로 구현하기**
순차 탐색을 사용할 경우 노드 개수에 따라 탐색 시간이 매우 오래 걸릴 수 있다. 이를 개선하기 위해 우선순위 큐를 도입하기도 한다.
거리 값을 담을 우선순위 큐는 힙으로 구현하고, 만약 최소 힙으로 구현한다면 매번 루트 노드가 최소 거리를 가지는 노드가 될 것이다.
파이썬의 경우 PriorityQueue나 heapq 라이브러리로 우선순위 큐, 최소 힙이 지원된다.  
간선의 수를 E(Edge), 노드의 수를 V(Vertex)라고 했을 때 **O(ElogV)** 가 된다.
우선순위 큐에서 꺼낸 노드는 연결된 노드만 탐색하므로 최악의 경우라도 총 간선 수인 E만큼만 반복한다. 즉 하나의 간선에 대해서는 **O(logE)** 이고, E는 V^2보다 항상 작기 때문에 E개의 간선을 우선순위 큐에 넣었다 빼는 최악의 경우에 대해서는 **O(ElogV)** 이다.

>두 방식의 자세한 코드는 [여기](https://sskl660.tistory.com/59)에 정리가 잘 되어있다!

## 출처

https://velog.io/@717lumos/%EC%95%8C%EA%B3%A0%EB%A6%AC%EC%A6%98-%EB%8B%A4%EC%9D%B5%EC%8A%A4%ED%8A%B8%EB%9D%BCDijkstra-%EC%95%8C%EA%B3%A0%EB%A6%AC%EC%A6%98#2-%EA%B5%AC%ED%98%841-%EC%88%9C%EC%B0%A8-%ED%83%90%EC%83%89  
https://sskl660.tistory.com/59  
